% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-bf.R
\name{plot_bf_heatmap}
\alias{plot_bf_heatmap}
\title{Plot Bayes Factor Heatmap (mean log10 BF10, Multi-Effect Grid Friendly)}
\usage{
plot_bf_heatmap(
  power_results,
  x_effect = NULL,
  y_effect = "n",
  facet_by = NULL,
  n = NULL,
  agg_fun = mean,
  title = NULL,
  subtitle = NULL
)
}
\arguments{
\item{power_results}{Simulation results from a \verb{brms_inla_power*} function with \code{compute_bayes_factor = TRUE}.}

\item{x_effect}{Name of effect grid column for x-axis (default: first grid column).}

\item{y_effect}{Name of effect grid column for y-axis (default: "n").}

\item{facet_by}{Optional column(s) to facet by.}

\item{n}{Optional sample size to filter to (NULL means plot all; else show only that n).}

\item{agg_fun}{Aggregation function (default: mean).}

\item{title, subtitle}{Optional plot labels.}
}
\value{
ggplot object.
}
\description{
Heatmap of mean log10 BF10 as a function of two effect grid columns (x/y), with optional faceting.
}
