% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GoodnessOfFit.R
\name{get_residuals}
\alias{get_residuals}
\title{Compute residuals of transformation to normality}
\usage{
get_residuals(x, transformer, ...)
}
\arguments{
\item{x}{A vector with numeric values that should be transformed to
normality.}

\item{transformer}{A transformer object created using
\code{find_transformation_parameters}.}

\item{...}{Unused arguments.}
}
\value{
A \code{data.table} containing the expected (according to a normal
distribution) and observed z-scores, and their difference as residuals.
}
\description{
Compute residuals of transformation to normality
}
\examples{
x <- exp(stats::rnorm(1000))
transformer <- find_transformation_parameters(
  x = x,
  method = "box_cox")

residual_data <- get_residuals(
  x = x,
  transformer = transformer)
}
