% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_xy.R
\name{read_xy}
\alias{read_xy}
\title{Read ASCII XY data}
\usage{
read_xy(files, header, sep)
}
\arguments{
\item{files}{path of the file(s) to be imported.}

\item{header}{a logical value indicating whether the file contains the names
of the variables as its first line. Default = \code{FALSE}.}

\item{sep}{the field separator character. Values on each line of the file
are separated by this character. Default = \code{" "}, indicating space
separated format.}
}
\value{
If only one path is supplied then an XY data frame with 2 columns is returned,
the first being the 2theta axis and the second being the count intensities. If more
than one path is supplied then a multiXY list is returned, with each item in the list being
an XY data frame as already described.
}
\description{
\code{read_xy} is a wrapper for \code{read.csv} that is designed for space separated XRPD
data.
}
\examples{
#load example XY file
file <- system.file("extdata/D5000/xy/D5000_1.xy", package = "powdR")
xy <- read_xy(file)

#Load multiple XY files
files <- dir(system.file("extdata/D5000/xy", package = "powdR"),
             full.names = TRUE)
xy_list <- read_xy(files)

\dontrun{
plot(xy_list, wavelength = "Cu")
plot(xy_list, wavelength = "Cu", interactive = TRUE)
}

}
