% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrownPOSet.R
\name{CrownPOSet}
\alias{CrownPOSet}
\title{Building crowns.}
\usage{
CrownPOSet(elements_1, elements_2)
}
\arguments{
\item{elements_1}{A list of character strings.}

\item{elements_2}{A list of character strings.}
}
\value{
A crown, an object of S4 class \code{POSet}.
}
\description{
Builds a crown from two unordered collections of elements, with the same size.
}
\details{
Let \eqn{a_1,\ldots,a_n} and \eqn{b_1,\ldots,b_n} be two disjoint collections of \eqn{n} elements.
The "crown" over them is the poset \eqn{P=(V,\lhd)} having \eqn{a_1,\ldots,a_n,b_1,\ldots,b_n}
as ground set and where \eqn{(a_i||a_j)}, \eqn{(b_i||b_j)}, \eqn{(a_i||b_i)} and \eqn{a_i\lhd b_j},
for each \eqn{i\neq j} (\eqn{||} stands for "incomparable to").
}
\examples{
elems1<-c("a1", "a2", "a3", "a4", "a5")
elems2<-c("b1", "b2", "b3", "b4", "b5")
crown<-CrownPOSet(elems1, elems2)

}
