% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{load_rodent_data}
\alias{load_rodent_data}
\alias{load_plant_data}
\alias{load_ant_data}
\alias{load_trapping_data}
\title{Read in the Portal data files}
\usage{
load_rodent_data(
  path = get_default_data_path(),
  download_if_missing = TRUE,
  clean = TRUE,
  quiet = FALSE
)

load_plant_data(
  path = get_default_data_path(),
  download_if_missing = TRUE,
  quiet = FALSE
)

load_ant_data(
  path = get_default_data_path(),
  download_if_missing = TRUE,
  quiet = FALSE
)

load_trapping_data(
  path = get_default_data_path(),
  download_if_missing = TRUE,
  clean = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{path}{either the file path that contains the PortalData folder or
"repo", which then pulls data from the PortalData GitHub repository}

\item{download_if_missing}{if the specified file path doesn't have the
PortalData folder, then download it}

\item{clean}{logical, load only QA/QC rodent data (TRUE) or all data (FALSE)}

\item{quiet}{logical, whether to run without version messages}
}
\value{
\code{\link{load_rodent_data}} returns a list of 5 dataframes:
  \tabular{ll}{
    \code{rodent_data} \tab raw data on rodent captures\cr
    \code{species_table} \tab species code, names, types\cr
    \code{trapping_table} \tab when each plot was trapped\cr
    \code{newmoons_table} \tab pairs census periods with newmoons\cr
    \code{plots_table} \tab rodent treatment assignments for each plot\cr
  }

\code{\link{load_plant_data}} returns a list of 7 dataframes:
  \tabular{ll}{
    \code{quadrat_data} \tab raw plant quadrat data\cr
    \code{species_table} \tab species code, names, types\cr
    \code{census_table} \tab indicates whether each quadrat was counted in each
      census; area of each quadrat\cr
    \code{date_table} \tab start and end date of each plant census\cr
    \code{plots_table} \tab rodent treatment assignments for each plot\cr
    \code{transect_data} \tab raw plant transect data with length and height (2015-present)\cr
    \code{oldtransect_data} \tab raw plant transect data as point counts (1989-2009)\cr
  }

\code{\link{load_ant_data}} returns a list of 4 dataframes:
  \tabular{ll}{
    \code{bait_data} \tab raw ant bait data\cr
    \code{colony_data} \tab raw ant colony data\cr
    \code{species_table} \tab species code, names, types\cr
    \code{plots_table} \tab treatment assignments for each plot\cr
  }

\code{\link{load_trapping_data}} returns a list of 2 dataframes:
  \tabular{ll}{
    \code{trapping_table} \tab when each plot was trapped\cr
    \code{newmoons_table} \tab pairs census periods with newmoons\cr
  }
}
\description{
Loads Portal data files from either a user-defined
  path or the online Github repository. If the user-defined path is un-
  available, the default option is to download to that location.

\code{\link{load_rodent_data}} loads the rodent data files

\code{\link{load_plant_data}} loads the plant data files

\code{\link{load_ant_data}} loads the ant data files

\code{\link{load_trapping_data}} loads just the rodent trapping files
}
\examples{
\donttest{
portal_data <- load_rodent_data("repo")
}
\donttest{
portal_plant_data <- load_plant_data("repo")
}
\donttest{
portal_ant_data <- load_ant_data("repo")
}
\donttest{
trapping_data <- load_trapping_data("repo")
}
}
