% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.r
\docType{methods}
\name{mll}
\alias{mll}
\alias{mll,genclone-method}
\alias{mll,snpclone-method}
\alias{mll,genind-method}
\alias{mll,genlight-method}
\alias{nmll}
\alias{nmll,genclone-method}
\alias{nmll,snpclone-method}
\alias{nmll,genind-method}
\alias{nmll,genlight-method}
\alias{mll<-}
\alias{mll<-,genclone-method}
\alias{mll<-,snpclone-method}
\title{Access and manipulate multilocus lineages.}
\usage{
mll(x, type = NULL)

nmll(x, type = NULL)

mll(x) <- value
}
\arguments{
\item{x}{a \linkS4class{genclone} or \linkS4class{snpclone} object.}

\item{type}{a character specifying "original", "contracted", or "custom"
defining they type of mlgs to return. Defaults to what is set in the
object.}

\item{value}{a character specifying which mlg type is visible in the object.
See details.}
}
\value{
an object of the same type as x.
}
\description{
The following methods allow the user to access and manipulate multilocus 
lineages in genclone or snpclone objects.
}
\details{
\linkS4class{genclone} and \linkS4class{snpclone} objects have a
  slot for an internal class of object called \linkS4class{MLG}. This class
  allows the storage of flexible mll definitions: \itemize{ \item "original"
  - naive mlgs defined by string comparison. This is default. \item
  "contracted" - mlgs defined by a genetic distance threshold. \item "custom"
  - user-defined MLGs }
}
\examples{

data(partial_clone)
pc <- as.genclone(partial_clone)
mll(pc)
mll(pc) <- "custom"
mll(pc)
mll.levels(pc) <- LETTERS
mll(pc)
}
\seealso{
\code{\link{mll.custom}} \code{\link{mlg.table}}
}
\author{
Zhian N. Kamvar
}
