% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ia_jackknife.R
\name{jack.ia}
\alias{jack.ia}
\title{Index of association with reduced data}
\usage{
jack.ia(gid, n = NULL, reps = 999, quiet = FALSE)
}
\arguments{
\item{gid}{a genind or genclone object}

\item{n}{an integer specifying the number of samples to be drawn. Defaults to
\code{NULL}, which then uses the number of multilocus genotypes.}

\item{reps}{an integer specifying the number of replicates to perform.
Defaults to 999.}

\item{quiet}{a logical. If \code{FALSE}, a progress bar will be displayed. 
If \code{TRUE}, the progress bar is suppressed}
}
\value{
a data frame with the index of association and standardized index of
association in columns. Number of rows represents the number of reps.
}
\description{
This function will perform the index of association on a reduced data set
multiple times to create a distribution, showing the variation of values
observed at a given sample size.
}
\examples{
data(Pinf)
jack.ia(Pinf, reps = 99)
}
\seealso{
\code{\link{ia}}, 
  \code{\link{pair.ia}}
}
