% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/filter_stats.R
\name{cutoff_predictor}
\alias{cutoff_predictor}
\title{Predict cutoff thresholds for use with mlg.filter}
\usage{
cutoff_predictor(thresholds, fraction = 0.5)
}
\arguments{
\item{thresholds}{a vector of numerics coming from mlg.filter where the
threshold has been set to the maximum threshold theoretically possible.}

\item{fraction}{the fraction of the data to seek the threshold.}
}
\value{
a numeric value representing the threshold at which multilocus
  lineages should be defined.
}
\description{
Given a series of thresholds for a data set that collapse it into one giant
cluster, this will search the top fraction of threshold differences to find
the largest difference. The average between the thresholds spanning that
difference is the cutoff threshold defining the clonal lineage threshold.
}
\note{
This function originally appeared in
  \href{http://dx.doi.org/10.5281/zenodo.17424}{DOI: 10.5281/zenodo.17424}.
  This is a bit of a blunt instrument.
}
\examples{
\dontrun{
data(Pinf)
pthresh <- mlg.filter(Pinf, distance = diss.dist, percent = TRUE,
                      threshold = 1.1, stats = "THRESH")
cutoff_predictor(pthresh)
}
}
\author{
Zhian N. Kamvar
}
\references{
ZN Kamvar, JC Brooks, and NJ Grünwald. 2015. Supplementary Material for
Frontiers Plant Genetics and Genomics 'Novel R tools for analysis of
genome-wide population genetic data with emphasis on clonality'. DOI:
\href{http://dx.doi.org/10.5281/zenodo.17424}{10.5281/zenodo.17424}

Kamvar ZN, Brooks JC and Grünwald NJ (2015) Novel R tools for analysis of
genome-wide population genetic data with emphasis on clonality. Front. Genet.
6:208. doi: \href{http://dx.doi.org/10.3389/fgene.2015.00208}{10.3389/fgene.2015.00208}
}

