% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/methods.r
\docType{methods}
\name{as.snpclone}
\alias{as.snpclone}
\alias{as.snpclone,genlight-method}
\title{Create a snpclone object from a genlight object.}
\usage{
as.snpclone(x, ..., parallel = require("parallel"), n.cores = NULL, mlg,
  mlgclass = TRUE)
}
\arguments{
\item{x}{a \code{\linkS4class{genlight}} or \code{\linkS4class{snpclone}}
object}

\item{...}{arguments to be passed on to the genlight constructor. These are
not used if x is not missing.}

\item{parallel}{should the parallel package be used to construct the object?}

\item{n.cores}{how many cores should be utilized? See documentation for
\code{\linkS4class{genlight}} for details.}

\item{mlg}{a vector of multilocus genotypes or an object of class MLG for the
new snpclone object.}

\item{mlgclass}{if \code{TRUE} (default), the multilocus genotypes will be
  represented as an \code{\linkS4class{MLG}} object.}
}
\description{
Wrapper for snpclone initializer.
}
\examples{
(x <- as.snpclone(glSim(100, 1e3, ploid=2)))
}
\author{
Zhian N. Kamvar
}

