% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{as.genclone}
\alias{as.genclone}
\alias{as.genclone,genind-method}
\title{Create a genclone object from a genind object.}
\usage{
as.genclone(x, hierarchy = NULL)
}
\arguments{
\item{x}{a \code{\linkS4class{genind}} or \code{\linkS4class{genclone}}
object}

\item{hierarchy}{a data frame representing the population hierarchy.}
}
\description{
Wrapper for genclone initializer.
}
\note{
The hierarchy must have the same number of rows as the number of
  observations in the genind object. If no hierarchy is defined, the function
  will search for a data frame in the \code{\link{other}} slot called
  "population_hierarchy" and set that as the hieararchy. If none is defined,
  the population will be set as the hierarchy under the label "Pop". Use the
  function \code{\link{splithierarchy}} to split up any population
  hierarchies that might be combined in the population factor.
}
\examples{
data(Aeut)
Aeut
Aeut.gc <- as.genclone(Aeut)
Aeut.gc
Aeut.gc <- as.genclone(Aeut, other(Aeut)$population_hierarchy[-1])
Aeut.gc
}
\author{
Zhian N. Kamvar
}
\seealso{
\code{\link{splithierarchy}}, \code{\linkS4class{genclone}},
  \code{\link{read.genalex}}
}

