% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfs_inertia&tfsm_inertia.R
\name{tfs_inertia}
\alias{tfs_inertia}
\alias{tfsm_inertia}
\title{Calculate sensitivity of inertia using transfer functions}
\usage{
tfs_inertia(A, d=NULL, e=NULL, vector="n", bound=NULL, startval=0.001, 
            tolerance=1e-10,return.fit=FALSE,plot.fit=FALSE)
tfsm_inertia(A,vector="n",bound=NULL,startval=0.001,tolerance=1e-10)
}
\arguments{
\item{A}{a square, primitive, nonnegative numeric matrix of any dimension}

\item{d, e}{numeric vectors that determine the perturbation structure 
(see details).}

\item{vector}{(optional) a numeric vector or one-column matrix describing 
the age/stage distribution ('demographic structure') used to calculate the
transfer function of a 'case-specific' inertia}

\item{bound}{(optional) specifies whether the transfer funciton of an upper 
or lower bound on inertia should be calculated (see details).}

\item{startval}{\code{tfs_inertia} calculates the limit of the derivative 
of the transfer function as lambda of the perturbed matrix approaches the 
dominant eigenvalue of \code{A} (see details). \code{startval} provides a 
starting value for the algorithm: the smaller \code{startval} is, the quicker 
the algorithm should converge.}

\item{tolerance}{the tolerance level for determining convergence (see
details).}

\item{return.fit}{if \code{TRUE} (and only if \code{d} and \code{e} are
specified), the lambda and sensitivity values obtained
from the convergence algorithm are returned alongside the sensitivity at the
limit.}

\item{plot.fit}{if \code{TRUE} then convergence of the algorithm is plotted
as sensitivity~lambda.}
}
\value{
For \code{tfs_inertia}, the sensitivity of inertia (or its bound) to 
the specified perturbation structure. If \code{return.fit=TRUE} a list 
containing components:
\describe{
\item{sens}{the sensitivity of inertia (or its bound) to the specified 
perturbation structure}
\item{lambda.fit}{the lambda values obtained in the fitting process}
\item{sens.fit}{the sensitivity values obtained in the fitting process.}\cr
For \code{tfsm_inertia}, a matrix containing sensitivity of inertia
(or its bound) to each separate element of \code{A}.
}
}
\description{
Calculate the sensitivity of population inertia of a population matrix 
projection model using differentiation of the transfer function.
}
\details{
\code{tfs_inertia} and \code{tfsm_inertia} differentiate a transfer function to
find sensitivity of population inertia to perturbations.

\code{tfs_inertia} evaluates the transfer function of a specific perturbation 
structure. The perturbation structure is determined by \code{d\%*\%t(e)}. 
Therefore, the rows to be perturbed are determined by \code{d} and the 
columns to be perturbed are determined by \code{e}. The values in d and e 
determine the relative perturbation magnitude. For example, if only entry
[3,2] of a 3 by 3 matrix is to be perturbed, then \code{d = c(0,0,1)} and 
\code{e = c(0,1,0)}. If entries [3,2] and [3,3] are to be perturbed with the 
magnitude of perturbation to [3,2] half that of [3,3] then \code{d = c(0,0,1)} 
and \code{e = c(0,0.5,1)}. \code{d} and \code{e} may also be expressed as 
numeric one-column matrices, e.g. \code{d = matrix(c(0,0,1), ncol=1)}, 
\code{e = matrix(c(0,0.5,1), ncol=1)}. See Hodgson et al. (2006) for more 
information on perturbation structures.

\code{tfsm_inertia} returns a matrix of sensitivity values for observed
transitions (similar to that obtained when using \code{\link{sens}} to
evaluate sensitivity of asymptotic growth), where a separate transfer function 
for each nonzero element of \code{A} is calculated (each element perturbed 
independently of the others).

The formula used by \code{tfs_inertia} and \code{tfsm_inertia} cannot be
evaluated at lambda-max, therefore it is necessary to find the limit of the
formula as lambda approaches lambda-max. This is done using a bisection
method, starting at a value of lambda-max + \code{startval}. \code{startval}
should be small, to avoid the potential of false convergence. The algorithm
continues until successive sensitivity calculations are within an accuracy
of one another, determined by \code{tolerance}: a \code{tolerance} of 1e-10
means that the sensitivity calculation should be accurate to 10 decimal
places. However, as the limit approaches lambda-max, matrices are no longer
invertible (singular): if matrices are found to be singular then
\code{tolerance} should be relaxed and made larger.

For \code{tfs_inertia}, there is an extra option to return and/or plot the above
fitting process using \code{return.fit=TRUE} and \code{plot.fit=TRUE}
respectively.
}
\examples{
  # Create a 3x3 matrix
  ( A <- matrix(c(0,1,2,0.5,0.1,0,0,0.6,0.6), byrow=TRUE, ncol=3) )

  # Create an initial stage structure    
  ( initial <- c(1,3,2) )

  # Calculate the sensitivity matrix for the upper bound on inertia
  tfsm_inertia(A, bound="upper",tolerance=1e-7)

  # Calculate the sensitivity of simultaneous perturbation to 
  # A[1,3] and A[2,3] for the lower bound on inertia
  tfs_inertia(A, d=c(1,0,0), e=c(0,1,1), bound="lower")

  # Calculate the sensitivity of simultaneous perturbation to 
  # A[1,3] and A[2,3] for specified initial stage structure
  # and return and plot the fitting process
  tfs_inertia(A, d=c(1,0,0), e=c(0,1,1), vector=initial,tolerance=1e-7,
              return.fit=TRUE,plot.fit=TRUE)

}
\references{
\itemize{
 \item Stott et al. (2012) Methods Ecol. Evol., 3, 673-684.
}
}
\seealso{
Other TransferFunctionAnalyses: 
\code{\link{tfa_inertia}()},
\code{\link{tfa_lambda}()},
\code{\link{tfam_inertia}()},
\code{\link{tfam_lambda}()},
\code{\link{tfs_lambda}()}

Other PerturbationAnalyses: 
\code{\link{elas}()},
\code{\link{sens}()},
\code{\link{tfa_inertia}()},
\code{\link{tfa_lambda}()},
\code{\link{tfam_inertia}()},
\code{\link{tfam_lambda}()},
\code{\link{tfs_lambda}()}
}
\concept{PVA}
\concept{PerturbationAnalyses}
\concept{TransferFunctionAnalyses}
\concept{demography}
\concept{ecology}
\concept{perturbation}
\concept{population}
\concept{population viability}
\concept{resilience}
\concept{systems control}
\concept{transfer function}
\concept{transient dynamics}
