% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R2Matlab.R
\name{R2Matlab}
\alias{R2Matlab}
\title{Convert matrices into Matlab style strings}
\usage{
R2Matlab(A, noquote = FALSE)
}
\arguments{
\item{A}{a numeric matrix of any dimension}

\item{noquote}{(optional) if \code{noquote=TRUE} then the returned character 
vector is printed without quotes.}
}
\value{
Object of class character representing \code{A} in a Matlab style.
}
\description{
Convert \R objects of class matrix into character strings that represent the 
matrix in a Matlab style
}
\details{
Matlab reads matrices using a unique one-line notation that can prove useful 
for storage in databases and importing multiple matrices into a program at 
once, amongst other applications.  This notation is by row, with "[" and "]" 
to specify the beginning and end of the matrix respectively, ";" to specify a 
new row and a space between each matrix element. Thus, the \R matrix created 
using \code{matrix(c(0,1,2,0.5,0.1,0,0,0.6,0.6), byrow=TRUE, ncol=3)} is 
equivalent to [0 1 2;0.5 0.1 0;0 0.6 0.6].

\code{R2Matlab} takes an \R object of class matrix converts it into a 
Matlab-style character string that may be useful for exporting into databases.
}
\examples{
  # Create a 3x3 PPM
  ( A <- matrix(c(0,1,2,0.5,0.1,0,0,0.6,0.6), byrow=TRUE, ncol=3) )

  # Code the matrix in a Matlab style
  R2Matlab(A)

  # Print without quotes
  R2Matlab(A, noquote=TRUE)

}
\seealso{
\code{\link{Matlab2R}}
}
\concept{Matlab}
