% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KeyfitzD.R
\name{KeyfitzD}
\alias{KeyfitzD}
\title{Calculate Keyfitz's delta}
\usage{
KeyfitzD(A, vector)
}
\arguments{
\item{A}{a square, irreducible, non-negative numeric matrix of any dimension.}

\item{vector}{a numeric vector or one-column matrix describing the age/stage 
distribution used to calculate the distance.}
}
\value{
Keyfitz's delta.
}
\description{
Calculate Keyfitz's delta for a population matrix projection model.
}
\details{
Keyfitz's delta is the sum of the differences between the stable demographic 
vector (the dominant right eigenvector of \code{A}) and the demographic 
distribution vector of the population (given by \code{vector}). 
\code{KeyfitzD} will not work for reducible matrices and returns a 
warning for imprimitive matrices (although will not function for imprimitive 
matrices with nonzero imaginary components in the dominant eigenpair).
}
\examples{
  # Create a 3x3 PPM
  ( A <- matrix(c(0,1,2,0.5,0.1,0,0,0.6,0.6), byrow=TRUE, ncol=3) )

  # Create an initial stage structure
  ( initial <- c(1,3,2) )
  
  # Calculate Keyfitz's delta
  KeyfitzD(A, vector=initial)

}
\references{
\itemize{
 \item Keyfitz (1968) Introduction to the Mathematics of Populations. Addison-Wesley.
 \item Stott et al. (2010) Ecol. Lett., 14, 959-970.
}
}
\seealso{
Other DistanceMeasures: 
\code{\link{CohenD}()},
\code{\link{projectionD}()}
}
\concept{DistanceMeasures}
\concept{distance}
