% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean.list.R
\name{mean.list}
\alias{mean.list}
\title{Mean matrix}
\usage{
\method{mean}{list}(x, ...)
}
\arguments{
\item{x}{A list of two or more matrices}

\item{\dots}{Additional arguments passed to \code{\link{rowMeans}}}
}
\value{
The mean matrix
}
\description{
Calculates mean matrix from a list of matrices
}
\details{
Returns the mean matrix from a list of matrices using a combination of
\code{\link{unlist}} and \code{\link{rowMeans}}.  See example for details.
}
\note{
S3 method for the \code{\link{mean}} of a list of matrices
}
\examples{
mean(hudsonia)
# or
x <- matrix(unlist(hudsonia), ncol=length(hudsonia) )
matrix2(rowMeans(x), colnames(hudsonia[[1]]))

}
\seealso{
\code{\link{var2}}
}
\author{
Chris Stubben
}
