% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{all_names_present}
\alias{all_names_present}
\title{Check if all names are present in given data}
\usage{
all_names_present(data, var.names, stops = TRUE, msg = NULL)
}
\arguments{
\item{data}{dataset where the variable names should be found}

\item{var.names}{a character vector of variable names, e.g.
\code{c("var1", "var2")}}

\item{stops}{logical, stop returns exception}

\item{msg}{Custom message to return instead of default message.
Special: include \code{\%\%VARS\%\%} in message string and the missing 
variable names will be inserted there (quoted, separated by comma, e.g. 
\code{'var1'}, \code{'var2'} --- no leading or tracing white space).}
}
\description{
Given a character vector, checks if all names are present in \code{names(data)}.
Throws error if \code{stops=TRUE}, else returns \code{FALSE} if some variable name is not present.
}
\seealso{
\code{\link{robust_values}}
}
\author{
Joonas Miettinen
}
