% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_document.R
\name{ICSS}
\alias{ICSS}
\title{Age standardisation weights from the ICSS scheme.}
\format{data.table with columns
\itemize{
 \item age - lower bound of the age group
 \item ICSS1 - first set of weights, sums to 100 000
 \item ICSS2 - second set of weights, sums to 100 000
 \item ICSS3 - third set of weights, sums to 100 000
}}
\source{
\href{http://seer.cancer.gov/stdpopulations/survival.html}{ICSS weights (US National Cancer Institute website)}

Corazziari, Isabella, Mike Quinn, and Riccardo Capocaccia. "Standard cancer patient population for age standardising survival ratios." European Journal of Cancer 40.15 (2004): 2307-2316.
}
\description{
Contains three sets age-standardisation weights for age-standardized survival (net, relative or observed).
}
\examples{
## aggregate weights to a subset of age groups
data(ICSS)
cut <- c(0, 30, 50, 70, Inf)
agegr <- cut(ICSS$age, cut, right = FALSE)
aggregate(ICSS1~agegr, data = ICSS, FUN = sum)
}

