% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.R
\name{print.grouped_data}
\alias{print.grouped_data}
\title{Print a grouped \code{data.frame}}
\usage{
\method{print}{grouped_data}(
  x,
  ...,
  digits = NULL,
  quote = FALSE,
  right = TRUE,
  row.names = TRUE,
  max = NULL
)
}
\arguments{
\item{x}{An object of class \code{grouped_data}.}

\item{...}{Additional arguments to \code{\link[=print]{print()}}.}

\item{digits}{the minimum number of significant digits to be used: see
    \code{\link[base]{print.default}}.}

\item{quote}{logical, indicating whether or not entries should be
    printed with surrounding quotes.}

\item{right}{logical, indicating whether or not strings should be
    right-aligned.  The default is right-alignment.}

\item{row.names}{logical (or character vector), indicating whether (or
    what) row names should be printed.}

\item{max}{numeric or \code{NULL}, specifying the maximal number of
    entries to be printed.  By default, when \code{NULL},
    \code{\link[base]{getOption}("max.print")} used.}
}
\description{
A print method for grouped \code{data.frame}s. Uses the standard \code{print.data.frame()} method but also reports the groups.
}
\examples{
mtcars \%>\% group_by(cyl, am) \%>\% print()

}
