% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pop_Gen_Functions.R
\name{EmpiricalSE}
\alias{EmpiricalSE}
\title{Calculate Empirical Standard Error}
\usage{
EmpiricalSE(datafile = data.frame, NLoci = 10)
}
\arguments{
\item{datafile}{A data frame containing genetic data from the
\link{LoadData}}

\item{NLoci}{Number of loci to sample in each iteration.}
}
\value{
A numeric vector containing the empirical standard error estimates.
}
\description{
This function calculates the empirical standard error based on repeated
sampling.
}
\examples{

genetic_data <- data.frame(
Locus = c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2),
Locus_allele = c("Marker1", "n", 1, 2, 3, "Marker2", "n", 1, 2, 3),
Sample1 = c(NA, 10, 0.5, 0.5, 0, NA, 10, 0.2, 0.3, 0.5),
Sample2 = c(NA, 20, 0.1, 0.2, 0.7, NA, 20, 0.3, 0.4, 0.3),
Sample3 = c(NA, 30, 0.3, 0.4, 0.3, NA, 30, 0.4, 0.2, 0.4)
)


EmpiricalSE(datafile=genetic_data, NLoci=3)
}
