% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik.R
\name{logLik}
\alias{logLik}
\alias{logLik,ANY-method}
\alias{logLik,missing-method}
\alias{logLik,listie-method}
\alias{logLik,pfilterd_pomp-method}
\alias{logLik,wpfilterd_pomp-method}
\alias{logLik,probed_pomp-method}
\alias{logLik,kalmand_pomp-method}
\alias{logLik,pmcmcd_pomp-method}
\alias{logLik,bsmcd_pomp-method}
\alias{logLik,objfun-method}
\alias{logLik,spect_match_objfun-method}
\alias{logLik,nlf_objfun-method}
\title{Log likelihood}
\usage{
logLik(object, ...)

\S4method{logLik}{listie}(object, ...)

\S4method{logLik}{pfilterd_pomp}(object)

\S4method{logLik}{wpfilterd_pomp}(object)

\S4method{logLik}{probed_pomp}(object)

\S4method{logLik}{kalmand_pomp}(object)

\S4method{logLik}{pmcmcd_pomp}(object)

\S4method{logLik}{bsmcd_pomp}(object)

\S4method{logLik}{objfun}(object)

\S4method{logLik}{spect_match_objfun}(object)

\S4method{logLik}{nlf_objfun}(object, ...)
}
\arguments{
\item{object}{fitted model object}

\item{\dots}{ignored}
}
\value{
numerical value of the log likelihood.
Note that some methods compute not the log likelihood itself but instead a related quantity.
To keep the code simple, the \code{logLik} function is nevertheless used to extract this quantity.

When \code{object} is of \sQuote{pfilterd_pomp} class (i.e., the result of a \code{wpfilter} computation), \code{logLik} retrieves the estimated log likelihood.

When \code{object} is of \sQuote{wpfilterd_pomp} class (i.e., the result of a \code{wpfilter} computation), \code{logLik} retrieves the estimated log likelihood.

When \code{object} is of \sQuote{probed_pomp} class (i.e., the result of a \code{\link{probe}} computation), \code{logLik} retrieves the \dQuote{synthetic likelihood}.

When \code{object} is of \sQuote{kalmand_pomp} class (i.e., the result of an \code{\link{eakf}} or \code{\link{enkf}} computation), \code{logLik} retrieves the estimated log likelihood.

When \code{object} is of \sQuote{pmcmcd_pomp} class (i.e., the result of a \code{\link{pmcmc}} computation), \code{logLik} retrieves the estimated log likelihood as of the last particle filter operation.

When \code{object} is of \sQuote{bsmcd_pomp} class (i.e., the result of a \code{\link{bsmc2}} computation), \code{logLik} retrieves the \dQuote{log evidence}.

When \code{object} is of \sQuote{spect_match_objfun} class (i.e., an objective function constructed by \code{\link{spect_objfun}}), \code{logLik} retrieves minus the spectrum mismatch.

When \code{object} is an NLF objective function, i.e., the result of a call to \code{\link{nlf_objfun}},
\code{logLik} retrieves the \dQuote{quasi log likelihood}.
}
\description{
Extract the estimated log likelihood (or related quantity) from a fitted model.
}
\seealso{
Other extraction methods: 
\code{\link{coef}()},
\code{\link{cond.logLik}()},
\code{\link{covmat}()},
\code{\link{eff.sample.size}()},
\code{\link{filter.mean}()},
\code{\link{filter.traj}()},
\code{\link{forecast}()},
\code{\link{obs}()},
\code{\link{pred.mean}()},
\code{\link{pred.var}()},
\code{\link{saved.states}()},
\code{\link{spy}()},
\code{\link{states}()},
\code{\link{summary}()},
\code{\link{timezero}()},
\code{\link{time}()},
\code{\link{traces}()}
}
\concept{extraction methods}
