% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_mean.R
\docType{methods}
\name{filter.mean}
\alias{filter.mean}
\alias{filter.mean,ANY-method}
\alias{filter.mean,missing-method}
\alias{filter.mean-kalmand_pomp}
\alias{filter.mean,kalmand_pomp-method}
\alias{filter.mean-pfilterd_pomp}
\alias{filter.mean,pfilterd_pomp-method}
\title{Filtering mean}
\usage{
\S4method{filter.mean}{kalmand_pomp}(object, vars, ...)

\S4method{filter.mean}{pfilterd_pomp}(object, vars, ...)
}
\arguments{
\item{object}{result of a filtering computation}

\item{vars}{optional character; names of variables}

\item{\dots}{ignored}
}
\description{
The mean of the filtering distribution
}
\details{
The filtering distribution is that of
\deqn{X(t_k) \vert Y(t_1)=y^*_1,\dots,Y(t_k)=y^*_k,}{Xk | Y1=y1*,\dots,Yk=yk*,}
where \eqn{X(t_k)}{Xk}, \eqn{Y(t_k)}{Yk} are the latent state and observable processes, respectively, and \eqn{y^*_t}{yt*} is the data, at time \eqn{t_k}{tk}.

The filtering mean is therefore the expectation of this distribution
\deqn{E[X(t_k) \vert Y(t_1)=y^*_1,\dots,Y(t_k)=y^*_k].}{E[Xk | Y1=y1*,\dots,Yk=yk*].}
}
\seealso{
More on particle-filter based methods in \pkg{pomp}: 
\code{\link{bsmc2}()},
\code{\link{cond.logLik}()},
\code{\link{eff.sample.size}()},
\code{\link{filter.traj}()},
\code{\link{kalman}},
\code{\link{mif2}()},
\code{\link{pfilter}()},
\code{\link{pmcmc}()},
\code{\link{pred.mean}()},
\code{\link{pred.var}()},
\code{\link{saved.states}()},
\code{\link{wpfilter}()}
}
\concept{particle_filter_methods}
