% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{homologue_lg_assignment}
\alias{homologue_lg_assignment}
\title{Assign markers to linkage groups and homologues.}
\usage{
homologue_lg_assignment(dosage_matrix, assigned_list, assigned_markertypes,
  SN_functions = NULL, LG_hom_stack, target_parent = "P1",
  other_parent = "P2", convert_palindrome_markers = TRUE, ploidy,
  ploidy2 = NULL, pairing = "random", LG_number, LOD_threshold = 3,
  write_intermediate_files = TRUE, log = NULL, ...)
}
\arguments{
\item{dosage_matrix}{A dosage matrix.}

\item{assigned_list}{List of \code{data.frames} with marker assignments for which the assignment analysis is already performed.}

\item{assigned_markertypes}{List of integer vectors of length 2. Specifying the markertypes in the same order as assigned_list.}

\item{SN_functions}{A vector of function names to be used. If NULL all remaining linkage functions with SN markers are used.}

\item{LG_hom_stack}{A \code{data.frame} with markernames (\code{"SxN_Marker"}), linkage group (\code{"LG"}) and homologue (\code{"homologue"})}

\item{target_parent}{A character string specifying the target parent.}

\item{other_parent}{A character string specifying the other parent.}

\item{convert_palindrome_markers}{Logical. Should markers that behave the same for both parents be converted to a workable format for that parent? E.g.: should 3.1 markers be converted to 1.3?}

\item{ploidy}{Ploidy level of parent 1. If parent 2 has the same ploidy level, then also the ploidy level of parent 2.}

\item{ploidy2}{Integer, by default \code{NULL}. If parental ploidies differ, use this to specify the ploidy of parent 2. Note that in cross-ploidy situations, ploidy2 must be smaller than ploidy.}

\item{pairing}{Type of pairing. Either \code{"random"} or \code{"preferential"}.}

\item{LG_number}{Expected number of chromosomes (linkage groups).}

\item{LOD_threshold}{LOD threshold at which a linkage is considered significant.}

\item{write_intermediate_files}{Logical. Write intermediate linkage files to working directory?}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}

\item{\dots}{Arguments passed to \code{\link{linkage}}}
}
\value{
A \code{data.frame} specifying marker assignments to linkage group and homologue.
}
\description{
This is a wrapper combining \code{\link{linkage}} and \code{\link{assign_linkage_group}}. It is used to assign all marker types to linkage groups by using linkage information with 1.0 markers. It allows for input of marker assignments for which this analysis has already been performed.
}
\examples{
\dontrun{
data("screened_data3", "P1_SxS_Assigned", "P1_DxN_Assigned", "LGHomDf_P1_1")
Assigned_markers<-homologue_lg_assignment(screened_data3,
                         assigned_list = list(P1_SxS_Assigned, P1_DxN_Assigned),
                         assigned_markertypes = list(c(1,1), c(2,0)),
                         LG_hom_stack = LGHomDf_P1_1,ploidy=4,LG_number = 5,
                         write_intermediate_files=FALSE)
                         }
}
