% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{phase_SN_diploid}
\alias{phase_SN_diploid}
\title{Phase 1.0 markers at the diploid level}
\usage{
phase_SN_diploid(linkage_df, cluster_list, LOD_chm = 3.5,
  LG_number = 3, independence_LOD = FALSE, log = NULL)
}
\arguments{
\item{linkage_df}{A linkage data.frame as output of \code{\link{linkage}} calculating linkage between 1.0 markers.}

\item{cluster_list}{A list of cluster_stacks, the output of \code{cluster_SN_markers}.}

\item{LOD_chm}{Integer. The LOD threshold specifying at which LOD score the markers divide into chromosomal groups}

\item{LG_number}{Expected number of chromosomes (linkage groups)}

\item{independence_LOD}{Logical. Should the LOD of independence be used for clustering? (by default, \code{FALSE}.)}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout (console).}
}
\value{
A data.frame with markers classified by homologue and linkage group.
}
\description{
\code{phase_SN_diploid} phases simplex x nulliplex markers for a diploid parent.
}
\examples{
data("SN_SN_P2_triploid","P2_homologues_triploid")
cluster_list2<-phase_SN_diploid(SN_SN_P2_triploid,P2_homologues_triploid,LOD_chm=5)
}
