% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\docType{methods}
\name{read}
\alias{read}
\alias{read,partition-method}
\alias{read,subcorpus-method}
\alias{read,partition_bundle-method}
\alias{read,data.table-method}
\alias{read,hits-method}
\alias{read,kwic-method}
\alias{read,regions-method}
\title{Display full text.}
\usage{
read(.Object, ...)

\S4method{read}{partition}(.Object, meta = NULL, highlight = list(),
  tooltips = list(), verbose = TRUE, cpos = TRUE,
  cutoff = getOption("polmineR.cutoff"),
  template = get_template(.Object), ...)

\S4method{read}{subcorpus}(.Object, meta = NULL, highlight = list(),
  tooltips = list(), verbose = TRUE, cpos = TRUE,
  cutoff = getOption("polmineR.cutoff"),
  template = get_template(.Object), ...)

\S4method{read}{partition_bundle}(.Object, highlight = list(),
  cpos = TRUE, ...)

\S4method{read}{data.table}(.Object, col, partition_bundle,
  highlight = list(), cpos = FALSE, ...)

\S4method{read}{hits}(.Object, def, i = NULL, ...)

\S4method{read}{kwic}(.Object, i = NULL,
  type = registry_get_properties(get_corpus(.Object))[["type"]])

\S4method{read}{regions}(.Object, meta = NULL)
}
\arguments{
\item{.Object}{an object to be read (\code{partition} or {partition_bundle})}

\item{...}{further parameters passed into read}

\item{meta}{a character vector supplying s-attributes for the metainformation
to be printed; if not stated explicitly, session settings will be used}

\item{highlight}{a named list of character vectors (see details)}

\item{tooltips}{a named list (names are colors, vectors are tooltips)}

\item{verbose}{logical}

\item{cpos}{logical, if TRUE, corpus positions will be assigned (invisibly) to a cpos
tag of a html element surrounding the tokens}

\item{cutoff}{maximum number of tokens to display}

\item{template}{template to format output}

\item{col}{column of \code{data.table} with terms to be highlighted}

\item{partition_bundle}{a \code{partition_bundle} object}

\item{def}{a named list used to define a partition (names are s-attributes, vectors are
values of s-attributes)}

\item{i}{if \code{.Object} is an object of the classes \code{kwic} or \code{hits},
the ith kwic line or hit to derive a partition to be inspected from}

\item{type}{the partition type, see documentation for \code{partition}-method}
}
\description{
Generate text (i.e. html) and display it in the viewer pane of RStudio for
reading it. If called on a \code{partition_bundle}-object, skip through the
partitions contained in the bundle.
}
\details{
To prepare the html output, the method \code{read} will call \code{html} and
\code{as.markdown} subsequently, the latter method being the actual worker.
Consult these methods to understand how preparing the output works.

The param \code{highlight} can be used to highlight terms. It is expected to
be a named list of character vectors, the names providing the colors, and the
vectors the terms to be highlighted. To add tooltips, use the param
\code{tooltips}.

The method \code{read} is a high-level function that calls the methods
mentioned before. Results obtained through \code{read} can also be obtained
through combining these methods in a pipe using the package \code{magrittr}.
That may offer more flexibility, e.g. to highlight matches for CQP queries.
See examples and the documentation for the different methods to learn more.
}
\examples{
use("polmineR")
merkel <- partition("GERMAPARLMINI", date = "2009-11-10", speaker = "Merkel", regex = TRUE)
if (interactive()) read(merkel, meta = c("speaker", "date"))
if (interactive()) read(
  merkel,
  highlight = list(yellow = c("Deutschland", "Bundesrepublik"), lightgreen = "Regierung"),
  meta = c("speaker", "date")
)

\dontrun{
pb <- as.speeches("GERMAPARLMINI", s_attribute_date = "date", s_attribute_name = "speaker")
pb <- pb[[ data.table::as.data.table(summary(pb))[size >= 500][["name"]] ]]
pb <- pb[[ 1:10 ]]
read(pb)
}
}
\seealso{
For concordances / a keword-in-context display, see \code{\link{kwic}}.
}
