% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kwic_class.R, R/enrich_method.R,
%   R/view_method.R
\docType{class}
\name{kwic-class}
\alias{kwic-class}
\alias{[,kwic,ANY,ANY,ANY-method}
\alias{[,kwic-method}
\alias{show,kwic-method}
\alias{as.data.frame,kwic-method}
\alias{enrich,kwic-method}
\alias{view,kwic-method}
\title{kwic (S4 class)}
\usage{
\S4method{show}{kwic}(object)

\S4method{as.data.frame}{kwic}(x)

\S4method{enrich}{kwic}(object, meta = NULL)

\S4method{view}{kwic}(.Object)
}
\arguments{
\item{object}{an object of class \code{kwic}}

\item{x}{a kwic-class object}

\item{meta}{sAttributes (character vector) with metainformation}

\item{.Object}{a kwic object}
}
\description{
S4 class for organizing information for concordance output
}
\section{Slots}{

\describe{
\item{\code{metadata}}{Object of class \code{"character"} keeping the sAttributes of the metadata that are to be displayed}

\item{\code{left}}{words to the left}

\item{\code{right}}{words to the right}

\item{\code{corpus}}{the CWB corpus}

\item{\code{cpos}}{the corpus positions}

\item{\code{table}}{Object of class \code{"data.frame"} a table with the relevant information for kwic output}

\item{\code{neighbor}}{Object of class \code{"character"} neighbor, if applicable}

\item{\code{encoding}}{Object of class \code{"character"} encoding of the corpus}

\item{\code{labels}}{Object of class \code{"character"}}

\item{\code{categories}}{Object of class \code{"character"}}
}}

\section{Methods}{

  \describe{
   \item{[}{indexing for seeing only some concordances}
   \item{show}{get kwic output}
  }
}

