% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4classes.R, R/p_attributes.R, R/count.R,
%   R/context.R, R/enrich.R, R/regions.R, R/trim.R
\docType{class}
\name{context-class}
\alias{context-class}
\alias{show,context-method}
\alias{[,context-method}
\alias{[,context,ANY,ANY,ANY-method}
\alias{[[,context-method}
\alias{summary,context-method}
\alias{head,context-method}
\alias{as.DataTables,context-method}
\alias{length,context-method}
\alias{p_attributes,context-method}
\alias{count,context-method}
\alias{sample,context-method}
\alias{enrich,context-method}
\alias{as.regions,context-method}
\alias{trim,context-method}
\title{Context class.}
\usage{
\S4method{length}{context}(x)

\S4method{p_attributes}{context}(.Object)

\S4method{count}{context}(.Object)

\S4method{sample}{context}(x, size)

\S4method{enrich}{context}(.Object, s_attribute = NULL, p_attribute = NULL,
  decode = FALSE, verbose = TRUE, ...)

\S4method{as.regions}{context}(x, node = TRUE)

\S4method{trim}{context}(object, s_attribute = NULL, positivelist = NULL,
  p_attribute = p_attributes(object), regex = FALSE, stoplist = NULL,
  verbose = TRUE, progress = TRUE, ...)
}
\arguments{
\item{x}{a context object}

\item{.Object}{object}

\item{size}{integer indicating sample size}

\item{s_attribute}{s-attribute(s) to add to data.table in cpos-slot}

\item{p_attribute}{p-attribute(s) to add to data.table in cpos-slot}

\item{decode}{logical, whether to convert integer ids to expressive strings}

\item{verbose}{logical, whether to be talkative}

\item{...}{to maintain backwards compatibility if argument \code{pAttribute} is still used}

\item{node}{A logical value, whether to include the node (i.e. query matches) in the region matrix
generated when creating a \code{partition} from a \code{context}-object.}

\item{object}{a context object}

\item{positivelist}{tokens that are required to be present to keep a match}

\item{regex}{logical, whether positivlist / stoplist is interpreted as regular expressions}

\item{stoplist}{tokens that are used to exclude a match}

\item{progress}{logical, whether to show progress bar}
}
\description{
Class to organize information of context analysis.
}
\details{
Objects of the class \code{context} include a \code{data.table} in the
slot \code{cpos}. The \code{data.table} will at least include the columns "hit_no",
"cpos" and "position".

The \code{length}-method will return the number of hits that were achieved.

The \code{enrich}-method can be used to add additional information to the \code{data.table}
in the "cpos"-slot of a \code{context}-object.
}
\section{Slots}{

\describe{
\item{\code{query}}{The query used/node examined (\code{character}).}

\item{\code{count}}{An \code{integer} value, the number of hits.}

\item{\code{partition}}{The \code{partition} the \code{context} object is based on.}

\item{\code{size_partition}}{A length-one \code{integer}, the size of the partition.}

\item{\code{left}}{An \code{integer} value, the number of tokens to the left.}

\item{\code{right}}{An \code{integer} value, the number of tokens to the right.}

\item{\code{size}}{An \code{integer} value, number of tokens in the right and left context of the node.}

\item{\code{boundary}}{An s-attribute (\code{character}).}

\item{\code{p_attribute}}{The p-attribute of the query (\code{character}).}

\item{\code{corpus}}{The CWB corpus used (\code{character}).}

\item{\code{stat}}{A \code{data.table}, the statistics of the analysis.}

\item{\code{encoding}}{Object of class \code{character}, encoding of the corpus.}

\item{\code{cpos}}{A \code{data.table}, with the columns hit_no, cpos, position, word_id.}

\item{\code{method}}{A \code{character}-vector, statistical test used.}

\item{\code{call}}{Object of class \code{character}, call that generated the object.}
}}

