% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blapply_method.R
\docType{methods}
\name{blapply}
\alias{blapply}
\alias{blapply,bundle-method}
\alias{blapply,list-method}
\alias{blapply,vector-method}
\title{apply a function over a list or bundle}
\usage{
blapply(x, ...)

\S4method{blapply}{list}(x, f, mc = TRUE, progress = TRUE,
  verbose = FALSE, ...)

\S4method{blapply}{vector}(x, f, mc = FALSE, progress = TRUE,
  verbose = FALSE, ...)

\S4method{blapply}{bundle}(x, f, mc = FALSE, progress = TRUE,
  verbose = FALSE, ...)
}
\arguments{
\item{x}{a list or a bundle object}

\item{...}{further parameters}

\item{f}{a function that can be applied to each object contained in the
bundle, note that it should swallow the parameters mc, verbose and progress
(use ... to catch these params )}

\item{mc}{logical, whether to use multicore - if TRUE, the number of cores
will be taken from the polmineR-options}

\item{progress}{logical, whether to display progress bar}

\item{verbose}{logical, whether to print intermediate messages}
}
\description{
Very similar to lapply, but applicable to bundle-objects, in particular.
The purpose of the method is to supply a uniform und convenient parallel
backend for the polmineR package. In particular, progress bars are supported
(the naming of the method is derived from bla bla).
}
\details{
Parallel backend supported so far are the parallel package (mclapply), and 
doMC, doParallel and doSNOW in combination with foreach. The parallel backend
to be used is taken from the option 'polmineR.backend' (getOption("polmineR.backend")),
the number of cores from the option 'polmineR.cores' (getOption("polmineR.cores")).
}
\examples{
if (require(polmineR.sampleCorpus) && require(rcqp)){
  use(polmineR.sampleCorpus)
  bt <- partition("PLPRBTTXT", list(text_id=".*"), regex=TRUE)
  speeches <- as.speeches(bt, sAttributeDates="text_date", sAttributeNames="text_name")
  foo <- blapply(speeches, function(x, ...) slot(x, "cpos"))
}
}

