% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtp.r
\name{xtp}
\alias{xtp}
\title{Cross tabulation Analysis}
\usage{
xtp(data, y, x, w = NULL, ylab = NULL, xlab = NULL, main = NULL,
  digits = 2, chisq = FALSE)
}
\arguments{
\item{data}{Dataset (like gss, nes, states, or world)}

\item{y}{Dependent variable}

\item{x}{Independent variable}

\item{w}{Weights (optional)}

\item{ylab}{Y-axis label (optional)}

\item{xlab}{X-axis label (optional)}

\item{main}{Main label for plot (optional)}

\item{digits}{Number of digits to report after decimal place, optional (default = 2)}

\item{chisq}{Do you want Chi-Squared test reported? (default is FALSE)}
}
\value{
A data frame of the cross tabulation results
}
\description{
Generates cross-tabulation of dependent and indendent variables, also creates a mosiac plot.  Makes use of the crosstab function in the descr package.
}
\examples{
   library(poliscidata)
   
   xtp(gss, grass, attend3, wtss)
}

