% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__expr.R
\name{Expr_rolling_var}
\alias{Expr_rolling_var}
\title{Rolling var}
\usage{
Expr_rolling_var(
  window_size,
  weights = NULL,
  min_periods = NULL,
  center = FALSE,
  by = NULL,
  closed = "left"
)
}
\arguments{
\item{window_size}{The length of the window. Can be a fixed integer size, or a dynamic temporal
size indicated by the following string language:
\itemize{
\item 1ns   (1 nanosecond)
\item 1us   (1 microsecond)
\item 1ms   (1 millisecond)
\item 1s    (1 second)
\item 1m    (1 minute)
\item 1h    (1 hour)
\item 1d    (1 day)
\item 1w    (1 week)
\item 1mo   (1 calendar month)
\item 1y    (1 calendar year)
\item 1i    (1 index count)
If the dynamic string language is used, the \code{by} and \code{closed} arguments must
also be set.
}}

\item{weights}{An optional slice with the same length as the window that will be multiplied
elementwise with the values in the window.}

\item{min_periods}{The number of values in the window that should be non-null before computing
a result. If None, it will be set equal to window size.}

\item{center}{Set the labels at the center of the window}

\item{by}{If the \code{window_size} is temporal for instance \code{"5h"} or \verb{"3s}, you must
set the column that will be used to determine the windows. This column must
be of dtype \verb{\{Date, Datetime\}}}

\item{closed}{: {'left', 'right', 'both', 'none'}
Define whether the temporal window interval is closed or not.}
}
\value{
Expr
}
\description{
Apply a rolling var (moving var) over the values in this array.
A window of length \code{window_size} will traverse the array. The values that fill
this window will (optionally) be multiplied with the weights given by the
\code{weight} vector. The resulting values will be aggregated to their sum.
}
\details{
This functionality is experimental and may change without it being considered a
breaking change.
Notes:
If you want to compute multiple aggregation statistics over the same dynamic
window, consider using \code{groupby_rolling} this method can cache the window size
computation.
}
\examples{
pl$DataFrame(list(a = 1:6))$select(pl$col("a")$rolling_var(window_size = 2))
}
\keyword{Expr}
