% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poismf.R
\name{get.model.mappings}
\alias{get.model.mappings}
\title{Extract user/row and item/column mappings from Poisson model.}
\usage{
get.model.mappings(model)
}
\arguments{
\item{model}{A Poisson factorization model as returned by `poismf`.}
}
\value{
A list with row entries: \itemize{
  \item `rows`: a vector in which each user/row ID is placed at its ordinal position
  in the internal data structures. If there is no mapping (e.g. if `X` passed to
  `poismf` was a sparse matrix), will be `NULL`.
  \item `columns`: a vector in which each item/column ID is placed at its ordinal position
  in the internal data structures. If there is no mapping (e.g. if `X` passed to
  `poismf` was a sparse matrix), will be `NULL`.
}
}
\description{
Will extract the mapping between IDs passed as `X` to
function `poismf` and row/column positions in the latent factor matrices
and prediction functions.

Such a mapping will only be generated if the `X` passed to `poismf` was a
`data.frame`, otherwise they will not be re-mapped.
}
\seealso{
\link{get.factor.matrices}
}
