% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_slack_prefs.R
\name{set_slack_prefs}
\alias{set_slack_prefs}
\title{Set Slack credentials and enable Slack notifications}
\usage{
set_slack_prefs(agent, notify_active = FALSE, slack_webhook_url,
  slack_channel, slack_username, slack_author_name = NULL,
  slack_title = NULL, slack_report_url = NULL,
  slack_footer_thumb_url = NULL, slack_footer_text = NULL)
}
\arguments{
\item{agent}{An agent object of class \code{ptblank_agent}.}

\item{notify_active}{An option to enable Slack notifications whenever any of
the validation steps in the \code{agent} object have triggered a \code{notify}
status.}

\item{slack_webhook_url}{The URL that is the endpoint for the API POST
request.}

\item{slack_channel}{The slack channel to which the notification message will
be posted.}

\item{slack_username}{The custom username associated with the webhook
integration.}

\item{slack_author_name}{An optional author name for the notification. If not
provided, then \code{pointblank} will be used as fallback text.}

\item{slack_title}{The title text for the notification. If not provided, the
name of the validation will be used.}

\item{slack_report_url}{An optional URL for a validation report that is
associated with the notification message. The link is embedded in the
\code{slack_title} text.}

\item{slack_footer_thumb_url}{An optional URL that is associated with the
thumbnail image in the notification footer.}

\item{slack_footer_text}{An optional snippet of text that will be part of the
notification footer.}
}
\value{
A \pkg{pointblank} agent object.
}
\description{
Grants Slack credentials to a pointblank agent object and provides an
opportunity to set Slack reporting options. This function is to be used in a
pointblank pipeline any time before an \code{\link[=interrogate]{interrogate()}} call.
}
\examples{
\dontrun{
# Create a simple data frame
# with a column of numerical values
df <-
  data.frame(
    a = c(5, 7, 6, 5, 8, 7))

# Create a pointblank `agent`,
# set up the Slack notification
# preferences, and conduct a
# simple validation; because
# `notify_count` (in the step
# where `col_vals_lt()` is called)
# has a value of `1` the
# `slack_channel` will be
# notified when there are one or
# more non-passing validations (in
# this case, non-passing rows)
agent <-
  create_agent() \%>\%
  set_slack_prefs(
    notify_active = TRUE,
    slack_webhook_url = 
      "https://hooks.slack.com/services/XXXXX/XXXXX/XXXXX",
    slack_channel = 
      "#table-validation",
    slack_username = "table_validator",
    slack_report_url = 
      "https:://my.company.com/reports/df_validation") \%>\%
  focus_on(tbl_name = "df") \%>\%
  col_vals_lt(
    column = a,
    value = 6,
    notify_count = 1) \%>\%
  interrogate()
}

}
