% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_ops.R
\name{set_tbl}
\alias{set_tbl}
\title{Set a data table to an \emph{agent} or an \emph{informant}}
\usage{
set_tbl(x, tbl, tbl_name = NULL, label = NULL)
}
\arguments{
\item{x}{An \emph{agent} object of class \code{ptblank_agent}, or, an \emph{informant} of
class \code{ptblank_informant}.}

\item{tbl}{The input table for the \emph{agent} or the \emph{informant}. This can be a
data frame, a tibble, a \code{tbl_dbi} object, or a \code{tbl_spark} object.
Alternatively, an expression can be supplied to serve as instructions on
how to retrieve the target table at interrogation- or incorporation-time.
There are two ways to specify an association to a target table: (1) as a
table-prep formula, which is a right-hand side (RHS) formula expression
(e.g., \verb{~ \{ <table reading code>\}}), or (2) as a function (e.g.,
\verb{function() \{ <table reading code>\}}).}

\item{tbl_name}{A optional name to assign to the new input table object. If
no value is provided, a name will be generated based on whatever
information is available.}

\item{label}{An optional label for the validation plan. If no value is
provided then any existing label will be retained.}
}
\description{
Setting a data table to an \emph{agent} or an \emph{informant} with \code{set_tbl()}
replaces any associated table (a data frame, a tibble, objects of class
\code{tbl_dbi} or \code{tbl_spark}).
}
\section{Examples}{


Set proportional failure thresholds to the \code{warn}, \code{stop}, and \code{notify}
states using \code{\link[=action_levels]{action_levels()}}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{al <- 
  action_levels(
      warn_at = 0.10,
      stop_at = 0.25,
    notify_at = 0.35
  )
}\if{html}{\out{</div>}}

Create an agent that has \code{small_table} set as the target table via \code{tbl}.
Apply the actions, add some validation steps and then interrogate the data.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent_1 <- 
  create_agent(
    tbl = small_table,
    tbl_name = "small_table",
    label = "An example.",
    actions = al
  ) \%>\%
  col_exists(columns = vars(date, date_time)) \%>\%
  col_vals_regex(
    columns = vars(b),
    regex = "[0-9]-[a-z]\{3\}-[0-9]\{3\}"
  ) \%>\%
  rows_distinct() \%>\%
  interrogate()
}\if{html}{\out{</div>}}

Replace the agent's association to \code{small_table} with a mutated version of it
(one that removes duplicate rows). Then, interrogate the new target table.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent_2 <-
  agent_1 \%>\%
  set_tbl(
    tbl = small_table \%>\% dplyr::distinct()
  ) \%>\%
  interrogate()
}\if{html}{\out{</div>}}
}

\section{Function ID}{

9-4
}

\seealso{
Other Object Ops: 
\code{\link{activate_steps}()},
\code{\link{deactivate_steps}()},
\code{\link{export_report}()},
\code{\link{remove_steps}()},
\code{\link{x_read_disk}()},
\code{\link{x_write_disk}()}
}
\concept{Object Ops}
