% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_wrap_var.R
\name{rename_wrap_var}
\alias{rename_wrap_var}
\title{Rename a variable in the xform_wrap transform object.}
\usage{
rename_wrap_var(wrap_object, xform_info = NA, ...)
}
\arguments{
\item{wrap_object}{Wrapper object obtained by using the xform_wrap function on the
raw data.}

\item{xform_info}{Specification of details of the renaming.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
R object containing the raw data, the transformed data and data
statistics.
}
\description{
Rename a variable in the xform_wrap transform object.
}
\details{
Once input data is wrapped by the \bold{xform_wrap} function, it is somewhat
involved to rename a variable inside. This function makes it easier to do
so.  Given a variable named \bold{input_var} and the name one wishes to
rename it to, \bold{output_var}, the rename command options are:

xform_info="input_var -> output_var"

There are two methods in which the variables can be referred to. The first
method is to use its column number; given the \bold{data} attribute of the
\bold{boxData} object, this would be the order at which the variable
appears. This can be indicated in the format "column#". The second method is
to refer to the variable by its name. This method will work even if the
renamed value already exists; in which case there will be two variables with
the same name.

If no input variable name is provided, the original object is returned with
no renaming performed.
}
\examples{
# Load the standard iris dataset, already built into R
data(iris)

# First wrap the data
iris_box <- xform_wrap(iris)

# We wish to refer to the variables "Sepal.Length" and
# "Sepal.Width" as "SL" and "SW"
iris_box <- rename_wrap_var(wrap_object = iris_box, xform_info = "column1->SL")
iris_box <- rename_wrap_var(wrap_object = iris_box, xform_info = "Sepal.Width->SW")
}
\seealso{
\code{\link{xform_wrap}}
}
\author{
Tridivesh Jena
}
\keyword{manip}
\keyword{methods}
\keyword{utilities}
