% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.gbm.R
\name{pmml.gbm}
\alias{pmml.gbm}
\title{Generate the PMML representation for a gbm object from the package \pkg{gbm}.}
\usage{
\method{pmml}{gbm}(model, model_name = "GBM_Model",
  app_name = "SoftwareAG PMML Generator",
  description = "Generalized Boosted Tree Model", copyright = NULL,
  transforms = NULL, missing_value_replacement = NULL, ...)
}
\arguments{
\item{model}{A \code{gbm} object.}

\item{model_name}{A name to be given to the PMML model.}

\item{app_name}{The name of the application that generated the PMML.}

\item{description}{A descriptive text for the Header element of the PMML.}

\item{copyright}{The copyright notice for the model.}

\item{transforms}{Data transformations.}

\item{missing_value_replacement}{Value to be used as the 'missingValueReplacement'
attribute for all MiningFields.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
PMML representation of the gbm object.
}
\description{
Generate the PMML representation for a gbm object from the package \pkg{gbm}.
}
\details{
The 'gbm' function uses various distribution types to fit a model; currently
only the "bernoulli", "poisson" and "multinomial" distribution types are
supported.

For all cases, the model output includes the gbm prediction type
"link" and "response".
}
\examples{
library(gbm)
data(audit)

mod <- gbm(Adjusted ~ .,
  data = audit[, -c(1, 4, 6, 9, 10, 11, 12)],
  n.trees = 3, interaction.depth = 4
)

mod_pmml <- pmml(mod)

# Classification example:
mod2 <- gbm(Species ~ .,
  data = iris, n.trees = 2,
  interaction.depth = 3, distribution = "multinomial"
)

# The PMML will include a regression model to read the gbm object outputs
# and convert to a "response" prediction type.
mod2_pmml <- pmml(mod2)
}
\references{
\href{https://CRAN.R-project.org/package=gbm}{gbm: Generalized Boosted
Regression Models (on CRAN)}
}
\author{
Tridivesh Jena
}
