% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmd.R
\name{getsda}
\alias{getsda}
\title{Perform structure/reaction directed analysis for peaks list.}
\usage{
getsda(
  list,
  rtcutoff = 10,
  corcutoff = NULL,
  digits = 2,
  accuracy = 4,
  freqcutoff = NULL
)
}
\arguments{
\item{list}{a list with mzrt profile}

\item{rtcutoff}{cutoff of the distances in retention time hierarchical clustering analysis, default 10}

\item{corcutoff}{cutoff of the correlation coefficient, default NULL}

\item{digits}{mass or mass to charge ratio accuracy for pmd, default 2}

\item{accuracy}{measured mass or mass to charge ratio in digits, default 4}

\item{freqcutoff}{pmd frequency cutoff for structures or reactions, default NULL. This cutoff will be found by PMD network analysis when it is NULL.}
}
\value{
list with tentative isotope, adducts, and neutral loss peaks' index, retention time clusters.
}
\description{
Perform structure/reaction directed analysis for peaks list.
}
\examples{
data(spmeinvivo)
pmd <- getpaired(spmeinvivo)
std <- getstd(pmd)
sda <- getsda(std)
}
\seealso{
\code{\link{getpaired}},\code{\link{getstd}},\code{\link{plotpaired}}
}
