% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_result.R
\name{cor_result}
\alias{cor_result}
\title{Compute Correlation matrix of biomolecule data}
\usage{
cor_result(omicsData)
}
\arguments{
\item{omicsData}{an object of the class 'lipidData', 'metabData', 'pepData',
'proData', 'nmrData', or 'seqData', created by
\code{\link{as.lipidData}}, \code{\link{as.metabData}},
\code{\link{as.pepData}}, \code{\link{as.proData}},
\code{\link{as.nmrData}}, or \code{\link{as.seqData}}, respectively.}
}
\value{
An \eqn{n \times n} matrix of class corRes giving the correlation
  between samples.
}
\description{
This function returns an object of class corRes (correlation Result)
}
\details{
The pairwise correlations between samples are calculated based on
  biomolecules that are observed in both samples. For seqData objects,
  Spearman correlation is used. For all other data types, Pearson correlation
  is used and data must be log transformed. See \code{\link{cor}} for further details.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)

mymetab <- edata_transform(omicsData = metab_object, data_scale = "log2")
my_correlation <- cor_result(omicsData = mymetab)

\donttest{
myseq_correlation <- cor_result(omicsData = rnaseq_object)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{edata_transform}}
}
\author{
Kelly Stratton, Lisa Bramer
}
