% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{VIP}
\alias{VIP}
\alias{SR}
\alias{sMC}
\alias{LW}
\alias{RC}
\alias{URC}
\alias{FRC}
\alias{mRMR}
\title{Filter methods for variable selection with Partial Least Squares.}
\usage{
VIP(pls.object, opt.comp, p = dim(pls.object$coef)[1])

SR(pls.object, opt.comp, X)

sMC(pls.object, opt.comp, X, alpha_mc = 0.05)

LW(pls.object, opt.comp)

RC(pls.object, opt.comp)

URC(pls.object, opt.comp)

FRC(pls.object, opt.comp)

mRMR(pls.object, nsel, X)
}
\arguments{
\item{pls.object}{\code{mvr} object from PLS regression.}

\item{opt.comp}{optimal number of components of PLS model.}

\item{p}{number of variables in PLS model.}

\item{X}{data matrix used as predictors in PLS modelling.}

\item{alpha_mc}{quantile significance for automatic selection of variables in \code{sMC}.}

\item{nsel}{number of variables to select.}
}
\value{
A vector having the same lenght as the number of variables in the associated
PLS model. High values are associated with high importance, explained variance or
relevance to the model.

The sMC has an attribute "quantile", which is the associated quantile of the
F-distribution, which can be used as a cut-off for significant variables, similar
to the cut-off of 1 associated with the VIP.
}
\description{
Various filter methods extracting and using information from 
\code{mvr} objects to assign importance to all included variables. Available 
methods are Significance Multivariate Correlation (sMC), Selectivity Ratio (SR), 
Variable Importance in Projections (VIP), Loading Weights (LW), Regression Coefficients (RC).
}
\details{
From plsVarSel 0.9.10, the VIP method handles multiple responses
correctly, as does the LW method. All other filter methods implemented in 
this package assume a single response and will give its results based on the
first response in multi-response cases.
}
\examples{
data(gasoline, package = "pls")
library(pls)
pls  <- plsr(octane ~ NIR, ncomp = 10, validation = "LOO", data = gasoline)
comp <- which.min(pls$validation$PRESS)
X    <- unclass(gasoline$NIR)
vip <- VIP(pls, comp)
sr  <- SR (pls, comp, X)
smc <- sMC(pls, comp, X)
lw  <- LW (pls, comp)
rc  <- RC (pls, comp)
urc <- URC(pls, comp)
frc <- FRC(pls, comp)
mrm <- mRMR(pls, 401, X)$score
matplot(scale(cbind(vip, sr, smc, lw, rc, urc, frc, mrm)), type = 'l')

}
\references{
T. Mehmood, K.H. Liland, L. Snipen, S. Sæbø, A review of variable selection 
methods in Partial Least Squares Regression, Chemometrics and Intelligent Laboratory Systems
118 (2012) 62-69.
T. Mehmood, S. Sæbø, K.H. Liland, Comparison of variable selection methods in partial least
squares regression, Journal of Chemometrics 34 (2020) e3226.
}
\seealso{
\code{\link{VIP}} (SR/sMC/LW/RC), \code{\link{filterPLSR}}, \code{\link{shaving}}, 
\code{\link{stpls}}, \code{\link{truncation}},
\code{\link{bve_pls}}, \code{\link{ga_pls}}, \code{\link{ipw_pls}}, \code{\link{mcuve_pls}},
\code{\link{rep_pls}}, \code{\link{spa_pls}},
\code{\link{lda_from_pls}}, \code{\link{lda_from_pls_cv}}, \code{\link{setDA}}.
}
\author{
Tahir Mehmood, Kristian Hovde Liland, Solve Sæbø.
}
