% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupcor.r
\name{groupcor}
\alias{groupcor}
\title{Calculates the correlation between measures within groups/units}
\usage{
groupcor(x, y, group, data, stat)
}
\arguments{
\item{x}{A vector.}

\item{y}{A vector.}

\item{group}{A vector that contains group/unit identifiers.}

\item{data}{A data frame.}

\item{stat}{The type of correlation coefficient to be calculated. One of "pearson", "kendall", or "spearman".}
}
\value{
A tibble data frame with group identifiers and calculated correlation coefficients.
}
\description{
Returns a tibble data frame with group/unit identifiers and the correlation coefficient between two measures for each group/unit in a data frame. This can be used to examine the relationsip between two factors within cases.
}
\examples{
\dontrun{
a <- runif(1000, min = 0, max = 1)
b <- a + rnorm(1000, mean = 0, sd =1)
c <- rep(c(1:10), times = 100)
data <- data.frame(a, b, c)
groupcor("a", "b", "c", data, "pearson")
print(dat)
}
}
\author{
Charles Crabtree \email{ccrabtr@umich.edu}
}

