% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_or.R
\name{table_or}
\alias{table_or}
\title{Table OR}
\usage{
table_or(
  glm_model_results,
  conf_level = 0.95,
  output = "tibble",
  confint_fast_estimate = FALSE
)
}
\arguments{
\item{glm_model_results}{Results from a binomial Generalised Linear Model (GLM), as produced by \code{\link[stats:glm]{stats::glm()}}.}

\item{conf_level}{Numeric value between 0.001 and 0.999 (default = 0.95) specifying the confidence level for the confidence interval.}

\item{output}{String describing of the output type (default = 'tibble'). Options include 'tibble' and 'gt'.}

\item{confint_fast_estimate}{Boolean (default = \code{FALSE}) indicating whether to use a faster estimate of the confidence interval. Note: this assumes normally distributed data, which may not be suitable for your data.}
}
\value{
The returned object depends on the \code{output} parameter:
\itemize{
\item If \code{output = 'tibble'}, the function returns an object of class "tbl_df", "tbl" and "data.frame".
\item If \code{output = 'gt'}, the function returns an object of class "gt_tbl" and "list"
}
}
\description{
Produces a formatted table showing the outputs from the Odds Ratio analysis,
including details on covariate characteristics and model results.
}
\details{
The table includes the following information:
\itemize{
\item Covariate characteristics:
\itemize{
\item Number of observations for each characteristic
\item Number of observiations resulting in the outcome of interest
\item Conversion rate of outcome by the number of observations
}
\item Model results:
\itemize{
\item Estimated Odds Ratio, standard error and p-value
\item Calculated confidence interval for the specified confidence level
}
\item A visualisation of the OR plot is also provided for an at-a-glance view of
the model results
}

Includes details on the characteristics of the covariates, such as:
\itemize{
\item the number of observations for each characteristic,
\item the number of observations resulting in the outcome of interest,
\item the conversion rate of outcome by the number of observations,
}

Details are calculated showing the:
\itemize{
\item estimated Odds Ratio, standard error and p-value,
\item calculated confidence interval for the confidence level,
}

Also included is a visualisation of the OR plot to provide an at-a-glance
view of the model results.
}
\examples{
# Load the Titanic dataset
df <- datasets::Titanic |>
  dplyr::as_tibble() |>
  # convert aggregated counts to individual observations
  dplyr::filter(n > 0) |>
  tidyr::uncount(weights = n) |>
  # convert character variables to factors
  dplyr::mutate(dplyr::across(dplyr::where(is.character), as.factor))

# Perform logistic regression using `glm`
lr <- stats::glm(
  data = df,
  family = 'binomial',
  formula = Survived ~ Class + Sex + Age
)

# Produce the Odds Ratio table as a tibble
table_or(lr)

# Produce the Odds Ratio table as a gt object
table_or(lr, output = 'gt')
}
