% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotluck.R
\name{sample.plotluck}
\alias{sample.plotluck}
\title{Run \code{plotluck} for a randomly generated formula.}
\usage{
sample.plotluck(data, ...)
}
\arguments{
\item{data}{a data frame}

\item{...}{additional parameters to be passed to \code{plotluck}, such as
\code{weights} and \code{opts}.}
}
\value{
a ggplot2 object.
}
\description{
\code{sample.plotluck} samples a formula as follows:
\itemize{
\item Uniformly draw the number of variables (1-3).
\item For each variable, uniformly choose one of the existing variable types from the data set (numeric, ordered or unordered factor).
\item Uniformly select one of the data frame columns of that type.
}
}
\examples{
set.seed(42)
data(iris)
sample.plotluck(iris)
}
\seealso{
\code{\link{plotluck}}
}

