% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_modify_hsv.R
\name{image_modify_hsv}
\alias{image_modify_hsv}
\title{Modify the H, S, V Values of a 
Color Vector or an Image}
\usage{
image_modify_hsv(
  x,
  set_h = NULL,
  add_h = NULL,
  mult_h = NULL,
  rescale_h = NULL,
  fun_h = NULL,
  set_s = NULL,
  add_s = NULL,
  mult_s = NULL,
  rescale_s = NULL,
  fun_s = NULL,
  set_v = NULL,
  add_v = NULL,
  mult_v = NULL,
  rescale_v = NULL,
  fun_v = NULL,
  result = "magick",
  res = 144
)
}
\arguments{
\item{x}{an image created by \code{image_read} or 
other functions in package magick. Alternatively, it 
can be a vector of colors.}

\item{set_h}{set H values with specific values.}

\item{add_h}{add specific 
values to current H values.}

\item{mult_h}{multiply the current values 
with specific values.}

\item{rescale_h}{a length 2 numeric vector 
specifying the desired range of H values, 
e. g., \code{rescale_h = c(0.6, 0.95)} which 
will make the smallest original value to 
be 0.6, and the largest, 0.95. Alternatively, 
it can be your own scaling function.}

\item{fun_h}{your own modifying function 
(e. g., \code{fun_h = sqrt}). Alternatively, it can 
be a list that designates how to use internal 
curves. See Details.}

\item{set_s, add_s, mult_s, rescale_s, fun_s}{parameters 
to change S values. Used in the same way as those 
for H. See above.}

\item{set_v, add_v, mult_v, rescale_v, fun_v}{parameters 
to change V values. Used in the same way as those 
for H. See above.}

\item{result}{the default is "magick", the output is 
a magick picture. When it is "raster", a matrix is created 
which can be use as a raster 
for \code{ggplot2::annotation_raster}.}

\item{res}{when the result is a magick picture, the 
\code{res} parameter used by \code{magick::image_graph}.
Default is 144.}
}
\description{
The function modifies the H (0 - 1), S, V values 
of a vector of colors or an image. The 
three channels can be modified separately.
However, the most frequently used is 
only the V modification.
The ways to modify include: setting values 
to some specified values (set_*), adding (add_*), 
multiplying the original values (mult_*), 
rescaling the original values (rescale_*), 
using a function to recompute values (fun_*). 
The most useful way is to use some internal 
curves that mimic those PS-like apps.
DO see Details.
}
\details{
\code{fun_*} can be a function or 
a named list which tells the 
function which internal function is to be used. 
You must ensure values used by the function 
specified by you to be in the range [0, 1] for 
H, S, V modification and [0, 255] for R, G, B
modification. Also, you'd better make sure 
the output values of the function are in 
 
When \code{fun_*} is a list, it should be written in the 
following way: 
\itemize{
  \item (1) \code{fun_* = list(fun = "s", c1 = -2, 
c2 = 2, domain = c(0, 1))} An "s" curve will be 
used. c1 points out how to deal with values below 
0.5, c2 with values above 0.5. For c1 and c2, a value 
larger than 0 means a curvature towards y = 1, and 
a value smaller than 0 means a curvature towards
y = 0. So, c1 < 0 and c2 > 0 will make an s shape 
curve. c1 and c2 can be any number, though 
those with absolute values below 4 are quite 
good (default is -2 and 2). 0 means no change. 
domain specifies the 
value domain to put the result. The default is 
c(0, 1) which means not to rescale, thus
0.1 is 0.1. However, if you 
set \code{domain = c(0.5, 1)}, 
then 0.1 will be 0.55. If you do not know how 
to set domain, just ignore it.
  \item (2) \code{fun_* = list(fun = "circle", 
value = 0.5)} When the fun 
is "circle" or "c", an arc will be used. value must 
be a number between -1 and 1 (default is 0.5). 
A number larger than 0 means the curvature is 
towards y = 1, and a number smaller than 0 means 
it is towards y = 0. value should not be 0.
  \item (3) \code{list(fun_* = "linear", x0 = 0.4, 
y0 = 0.6)} This makes a linear modification except 
that there is a breakpoint. The default point is 
(0.4, 0.6) which means: suppose all the original numbers
and output numbers are in the [0, 1] range and 
the points with their x position smaller than 0.4 will 
be put along the line that links (0, 0) and (0.4, 0.6), 
and, those with x position larger than 0.4 will be put 
along the line that links (0.4, 0.6) and (1, 1). 
}
}
\examples{
\donttest{
# First create an image
library(magick)
mycolor=grDevices::hsv(0, s=seq(0.1, 0.9, 0.1), 
	v=seq(0.1, 0.9, 0.1))
img=image_graph(width=400, height=400)
print(showcolor(mycolor)+theme_void())
dev.off()
# Now increase S values with 
# an internal circle curve and 
# set V values between [0.5, 1].
res=image_modify_hsv(img, 
	fun_s=list("circle", value=1), 
	rescale_v=c(0.5, 1))
}
}
