% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plm-package.R
\docType{data}
\name{Wages}
\alias{Wages}
\title{Panel Data of Individual Wages}
\format{
A data frame containing:
\describe{
\item{exp}{years of full-time work experience.}
\item{wks}{weeks  worked.}
\item{bluecol}{blue collar?}
\item{ind}{works in a manufacturing industry?}
\item{south}{resides in the south?}
\item{smsa}{resides in a standard metropolitan statistical area?}
\item{married}{married?}
\item{sex}{a factor with levels \code{"male"} and \code{"female"}}
\item{union}{individual's wage set by a union contract?}
\item{ed}{years of education.}
\item{black}{is the individual black?}
\item{lwage}{logarithm of wage.} }
}
\source{
Online complements to Baltagi (2001):

\url{https://www.wiley.com/legacy/wileychi/baltagi/}

Online complements to Baltagi (2013):

\url{http://bcs.wiley.com/he-bcs/Books?action=resource&bcsId=4338&itemId=1118672321&resourceId=13452}
}
\description{
A panel of 595 individuals from 1976 to 1982, taken from the Panel Study of
Income Dynamics (PSID).\cr\cr The data are organized as a stacked time
series/balanced panel, see \strong{Examples} on how to convert to a
\code{pdata.frame}.
}
\details{
\emph{total number of observations} : 4165

\emph{observation} : individuals

\emph{country} : United States
}
\examples{

# data set 'Wages' is organized as a stacked time series/balanced panel
data("Wages", package = "plm")
Wag <- pdata.frame(Wages, index=595)

}
\references{
\insertRef{BALT:01}{plm}

\insertRef{BALT:13}{plm}

\insertRef{CORN:RUPE:88}{plm}
}
\keyword{datasets}
