% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_pi.R
\name{aneweytest}
\alias{aneweytest}
\title{Chamberlain estimator and test for fixed effects}
\usage{
aneweytest(formula, data, subset, na.action, index = NULL, ...)
}
\arguments{
\item{formula}{a symbolic description for the model to be estimated,}

\item{data}{a \code{data.frame},}

\item{subset}{see \code{\link[=lm]{lm()}},}

\item{na.action}{see \code{\link[=lm]{lm()}},}

\item{index}{the indexes,}

\item{\dots}{further arguments.}
}
\value{
An object of class \code{"htest"}.
}
\description{
Angrist and Newey's version of the Chamberlain test
}
\details{
Angrist and Newey's test is based on the results of the artifactual
regression of the within residuals on the covariates for all the
periods.
}
\examples{

data("RiceFarms", package = "plm")
aneweytest(log(goutput) ~ log(seed) + log(totlabor) + log(size), RiceFarms, index = "id")

}
\references{
\insertRef{ANGR:NEWE:91}{plm}
}
\author{
Yves Croissant
}
\keyword{htest}
