% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shapefile.R
\name{shapefile_operations}
\alias{shapefile_operations}
\alias{shapefile_within}
\alias{shapefile_outside}
\alias{shapefile_overlaps}
\alias{shapefile_touches}
\alias{shapefile_crosses}
\alias{shapefile_intersection}
\alias{shapefile_difference}
\alias{shapefile_union}
\title{Spatial Operations on Shapefiles}
\usage{
shapefile_within(shp1, shp2)

shapefile_outside(shp1, shp2)

shapefile_overlaps(shp1, shp2)

shapefile_touches(shp1, shp2)

shapefile_crosses(shp1, shp2)

shapefile_intersection(shp1, shp2)

shapefile_difference(shp1, shp2)

shapefile_union(shp1, shp2)
}
\arguments{
\item{shp1}{An \code{sf} object representing the first shapefile.}

\item{shp2}{An \code{sf} object representing the second shapefile.}
}
\value{
A filtered \code{sf} object or the result of the geometric operation.
}
\description{
These functions perform various spatial operations on two shapefiles, including determining which geometries fall within, outside, touch, cross, overlap, or intersect another geometry. They also include functions for geometric operations such as intersection, difference, and union.
}
\details{
All functions ensure that the coordinate reference systems (CRS) of both shapefiles are the same before performing operations. If the CRSs are different, \code{shp2} will be transformed to match the CRS of \code{shp1}.
\itemize{
\item \code{shapefile_within()}: Filters features in \code{shp1} that are fully within \code{shp2}.
\item \code{shapefile_outside()}: Filters features in \code{shp1} that are outside or do not overlap \code{shp2}.
\item \code{shapefile_overlaps()}: Filters features in \code{shp1} that overlap with \code{shp2}.
\item \code{shapefile_touches()}: Filters features in \code{shp1} that touch the boundary of \code{shp2}.
\item \code{shapefile_crosses()}: Filters features in \code{shp1} that cross through \code{shp2}.
\item \code{shapefile_intersection()}: Computes the geometric intersection of \code{shp1} and \code{shp2}.
\item \code{shapefile_difference()}: Computes the geometric difference of \code{shp1} minus \code{shp2}.
\item \code{shapefile_union()}: Computes the geometric union of \code{shp1} and \code{shp2}.
}
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)

shp1 <- shapefile_input(paste0(image_pliman(), "/shp1.rds"))
shp2 <- shapefile_input(paste0(image_pliman(), "/shp2.rds"))
shapefile_view(shp1) + shapefile_view(shp1)

# Apply operations
shapefile_within(shp1, shp2)
shapefile_outside(shp1, shp2)
shapefile_overlaps(shp1, shp2)
shapefile_touches(shp1, shp2)
shapefile_crosses(shp1, shp2)
shapefile_intersection(shp1, shp2)
shapefile_difference(shp1, shp2)
shapefile_union(shp1, shp2)
}
}
