% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_landmarks.R
\name{landmarks}
\alias{landmarks}
\title{Create image landmarks}
\usage{
landmarks(
  img,
  n = Inf,
  viewer = get_pliman_viewer(),
  scale = NULL,
  calibrate = FALSE
)
}
\arguments{
\item{img}{An \code{Image} object.}

\item{n}{The number of landmarks to produce. Defaults to \code{Inf}. In this case,
landmarks are chosen up to the user press Esc.}

\item{viewer}{The viewer option. If not provided, the value is retrieved
using \code{\link[=get_pliman_viewer]{get_pliman_viewer()}}. This option controls the type of viewer to use
for interactive plotting. The available options are "base" and "mapview".
If set to "base", the base R graphics system is used for interactive
plotting. If set to "mapview", the mapview package is used. To set this
argument globally for all functions in the package, you can use the
\code{\link[=set_pliman_viewer]{set_pliman_viewer()}} function. For example, you can run
\code{set_pliman_viewer("mapview")} to set the viewer option to "mapview" for
all functions.}

\item{scale}{A known scale of the coordinate values. If \code{NULL} (default)
\code{scale = 1} is used.}

\item{calibrate}{A logical argument indicating whether a calibration step
must be performed before picking up the landmarks. If so, \code{\link[=calibrate]{calibrate()}} is
called internally. Users must then select two points and indicate a known
distance. A scale value will internally be computed and used in the
correction of the coordinates (from pixels to the unit of the known
distance).}
}
\value{
A \code{data.frame} with the \code{x} and \code{y}-coordinates from the landmarks.
}
\description{
An interactive section where the user will be able to click on the image to
select landmarks manually is open. With each mouse click, a point is drawn
and an upward counter is shown in the console. After \code{n} counts or after the
user press Esc, the interactive process is interrupted and a \code{data.frame}
with the \code{x} and \code{y} coordinates for the landmarks is returned.
}
\examples{
if(isTRUE(interactive())){
library(pliman)
img <- image_pliman("potato_leaves.jpg")
x <- landmarks(img)
}
}
\references{
Claude, J. (2008) \emph{Morphometrics with R}, Use R! series,
Springer 316 pp.
}
