% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RHtoVPD.R
\name{RHtoVPD}
\alias{DewtoVPD}
\alias{RHairToLeaf}
\alias{RHleafToAir}
\alias{RHtoVPD}
\alias{VPDairToLeaf}
\alias{VPDleafToAir}
\alias{VPDtoRH}
\alias{esat}
\title{Conversions between relative humidity, vapour pressure deficit and dewpoint}
\usage{
RHtoVPD(RH, TdegC, Pa = 101)

VPDtoRH(VPD, TdegC, Pa = 101)

esat(TdegC, Pa = 101)

DewtoVPD(Tdew, TdegC, Pa = 101)

VPDleafToAir(VPD, Tleaf, Tair, Pa = 101)

VPDairToLeaf(VPD, Tair, Tleaf, Pa = 101)

RHleafToAir(RH, Tleaf, Tair, Pa = 101)

RHairToLeaf(RH, Tair, Tleaf, Pa = 101)
}
\arguments{
\item{RH}{Relative humidity (\%)}

\item{TdegC}{Temperature (degrees C) (either leaf or air)}

\item{Pa}{Atmospheric pressure (kPa)}

\item{VPD}{Vapour pressure deficit (kPa)}

\item{Tdew}{Dewpoint temperature (degrees C)}

\item{Tleaf}{Leaf temperature (degrees C)}

\item{Tair}{Air temperature (degrees C)}
}
\description{
Converts relative humidity (\%) to vapour pressure deficit (kPa), or vice versa.
To convert from relative humidity, use the \code{RHtoVPD} function,
use \code{VPDtoRH} for the other way around. The water vapor saturation pressure is
calculated with \code{esat} (using Jones 1992). Also provided is \code{DewtoVPD} to
convert from dewpoint temperature to VPD. The functions \code{VPDleafToAir} and \code{VPDairToLeaf}
convert VPD from a leaf temperature to an air-temperature basis and vice versa.
}
\author{
Remko Duursma
}
\references{
Jones, H.G. 1992. Plants and microclimate: a quantitative approach to environmental plant physiology. 2nd Edition., 2nd Edn. Cambridge University Press, Cambridge. 428 p.
}

