% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archive.R
\name{cran_archive_cache}
\alias{cran_archive_cache}
\title{Cache for CRAN archive data}
\description{
This is an R6 class that implements a cache from older CRAN package
versions. For a higher level interface see the functions documented
with \code{\link[=cran_archive_list]{cran_archive_list()}}.
}
\details{
The cache is similar to \link{cranlike_metadata_cache} and has the following
layers:
\itemize{
\item The data inside the \code{cran_archive_cache} object.
\item Cached data in the current R session.
\item An RDS file in the current session's temporary directory.
\item An RDS file in the user's cache directory.
}

It has a synchronous and an asynchronous API.
}
\section{Usage}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{cac <- cran_archive_cache$new(
  primary_path = NULL,
  replica_path = tempfile(),
  cran_mirror = default_cran_mirror(),
  update_after = as.difftime(7, units = "days"),
)

cac$list(packages = NULL, update_after = NULL)
cac$async_list(packages = NULL, update_after = NULL)

cac$update()
cac$async_update()

cac$check_update()
cac$async_check_update()

cac$summary()

cac$cleanup(force = FALSE)
}\if{html}{\out{</div>}}
}

\section{Arguments}{

\itemize{
\item \code{primary_path}: Path of the primary, user level cache. Defaults to
the user level cache directory of the machine.
\item \code{replica_path}: Path of the replica. Defaults to a temporary directory
within the session temporary directory.
\item \code{cran_mirror}: CRAN mirror to use, this takes precedence over \code{repos}.
\item \code{update_after}: \code{difftime} object. Automatically update the cache if
it gets older than this. Set it to \code{Inf} to avoid updates. Defaults
to seven days.
\item \code{packages}: Packages to query, character vector.
\item \code{force}: Whether to force cleanup without asking the user.
}
}

\section{Details}{


Create a new archive cache with \code{cran_archive_cache$new()}. Multiple
caches are independent, so e.g. if you update one of them, the other
existing caches are not affected.

\code{cac$list()} lists the versions of the specified packages, or all
packages, if none were specified. \code{cac$async_list()} is the same, but
asynchronous.

\code{cac$update()} updates the cache. It always downloads the new metadata.
\code{cac$async_update()} is the same, but asynchronous.

\code{cac$check_update()} updates the cache if there is a newer version
available. \code{cac$async_check_update()} is the same, but asynchronous.

\code{cac$summary()} returns a summary of the archive cache, a list with
entries:
\itemize{
\item \code{cachepath}: path to the directory of the main archive cache,
\item \code{current_rds}: the RDS file that stores the cache. (This file might
not exist, if the cache is not downloaded yet.)
\item \code{lockfile}: the file used for locking the cache.
\item `timestamp: time stamp for the last update of the cache.
\item \code{size}: size of the cache file in bytes.
}

\code{cac$cleanup()} cleans up the cache files.
}

\section{Columns}{

\code{cac$list()} returns a data frame with columns:
\itemize{
\item \code{package}: package name,
\item \code{version}: package version. This is a character vector, and not
a \code{\link[=package_version]{package_version()}} object. Some older package versions are not
supported by \code{\link[=package_version]{package_version()}}.
\item \code{raw}: the raw row names from the CRAN metadata.
\item \code{mtime}: \code{mtime} column from the CRAN metadata. This is usually
pretty close to the release date and time of the package.
\item \code{url}: package download URL.
\item \code{mirror}: CRAN mirror that was used to get this data.
}
}

\examples{
\dontshow{if (pkgcache:::run_examples()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
arch <- cran_archive_cache$new()
arch$update()
arch$list()
\dontshow{\}) # examplesIf}
}
