% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata-cache.R
\name{meta_cache_deps}
\alias{meta_cache_deps}
\alias{meta_cache_revdeps}
\alias{meta_cache_update}
\alias{meta_cache_list}
\alias{meta_cache_cleanup}
\alias{meta_cache_summary}
\title{Query CRAN(like) package data}
\usage{
meta_cache_deps(packages, dependencies = NA, recursive = TRUE)

meta_cache_revdeps(packages, dependencies = NA, recursive = TRUE)

meta_cache_update()

meta_cache_list(packages = NULL)

meta_cache_cleanup(force = FALSE)

meta_cache_summary()
}
\arguments{
\item{packages}{Packages to query.}

\item{dependencies}{Dependency types to query. See the \code{dependencies}
parameter of \code{\link[utils:install.packages]{utils::install.packages()}}.}

\item{recursive}{Whether to query recursive dependencies.}

\item{force}{Whether to force cleanup without asking the user.}
}
\value{
A data frame (tibble) of the dependencies. For
\code{meta_cache_deps()} and \code{meta_cache_revdeps()} it includes the
queried \code{packages} as well.
}
\description{
It uses CRAN and BioConductor packages, for the current platform and
R version, from the default repositories.
}
\details{
\code{meta_cache_list()} lists all packages.

\code{meta_cache_update()} updates all metadata. Note that metadata is
automatically updated if it is older than seven days.

\code{meta_cache_deps()} queries packages dependencies.

\code{meta_cache_revdeps()} queries reverse package dependencies.

\code{meta_cache_summary()} lists data about the cache, including its location
and size.

\code{meta_cache_cleanup()} deletes the cache files from the disk.
}
\examples{
\dontshow{if (asNamespace("pkgcache")$is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
meta_cache_list("pkgdown")
meta_cache_deps("pkgdown", recursive = FALSE)
meta_cache_revdeps("pkgdown", recursive = FALSE)
\dontshow{\}) # examplesIf}
}
