% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_error_fun.R
\name{check_error_fun}
\alias{check_error_fun}
\title{Check that the \code{error_fun} is valid.}
\usage{
check_error_fun(error_fun)
}
\arguments{
\item{error_fun}{function that determines the error between
a given phylogeny and a the trees in a Bayesian posterior.
The function must have two arguments:
\itemize{
  \item the one given phylogeny, of class \link[ape]{phylo}
  \item one or more posterior trees, of class \link[ape]{multiphylo}
}
The function must return as many errors as there are posterior
trees given. The error must be lowest between identical trees.
Example functions are:
\itemize{
  \item \link{get_gamma_error_fun}: use the absolute difference
    in gamma statistic
  \item \link{get_nltt_error_fun}: use the nLTT statistic
}}
}
\value{
nothing
}
\description{
Will \link{stop} if not.
}
\examples{
# Check cleanup by other functions
beastier::check_empty_beaustier_folders()

check_error_fun(get_gamma_error_fun())
check_error_fun(get_nltt_error_fun())

}
\author{
Richèl J.C. Bilderbeek
}
