% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pir_run_twin_tree.R
\name{pir_run_twin_tree}
\alias{pir_run_twin_tree}
\title{Measure the error BEAST2 makes from a phylogeny}
\usage{
pir_run_twin_tree(twin_phylogeny, pir_params = create_test_pir_params())
}
\arguments{
\item{twin_phylogeny}{a phylogeny of class \link[ape]{phylo}}

\item{pir_params}{the parameters of \link[pirouette]{pirouette}.
They are created by \link{create_pir_params}.}
}
\value{
a data frame with errors, with as many rows as model selection
  parameter sets
}
\description{
The phylogeny can be the true tree or its twin.
}
\examples{
if (beautier::is_on_ci() && beastier::is_beast2_installed()) {

  # Create a true phylogeny to simulate the DNA sequences on
  n_taxa <- 5
  set.seed(1)
  phylogeny <- ape::rcoal(n_taxa)

  # Simulate and save the true alignment
  alignment_params <- create_test_alignment_params()
  create_tral_file(
    phylogeny = phylogeny,
    alignment_params = alignment_params
  )

  # Create a twin phylogeny to simulate the DNA sequences on
  set.seed(2)
  twin_phylogeny <- ape::rcoal(n_taxa)
  twinning_params <- create_twinning_params()

  # Simulate and save the twin alignment
  alignment <- create_twal_file(
    twin_phylogeny = twin_phylogeny,
    alignment_params = alignment_params,
    twinning_params = twinning_params
  )

  # Bundle parameters in pir_params
  pir_params <- create_test_pir_params()
  pir_params$alignment_params <- alignment_params
  pir_params$twinning_params <- twinning_params
  pir_params <- init_pir_params(pir_params)

  pir_run_twin_tree(
    twin_phylogeny = twin_phylogeny,
    pir_params = pir_params
  )
}
}
\author{
Richèl J.C. Bilderbeek, Giovanni Laudanno
}
