% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo_to_errors.R
\name{phylo_to_errors}
\alias{phylo_to_errors}
\title{Measure the error BEAST2 makes from a true phylogeny.}
\usage{
phylo_to_errors(
  phylogeny,
  alignment_params,
  experiment,
  error_measure_params = create_error_measure_params(),
  verbose = FALSE
)
}
\arguments{
\item{phylogeny}{a phylogeny of class \link[ape]{phylo}}

\item{alignment_params}{parameters to simulate an alignment,
as can be created by \link{create_alignment_params}}

\item{experiment}{a \link{pirouette} experiment,
as can be created by \link{create_experiment}}

\item{error_measure_params}{parameter set to specify how the
error between the given phylogeny and the Bayesian
posterior is determined.
Use \link{create_error_measure_params} to create such
a parameter set}

\item{verbose}{if TRUE, show more output}
}
\value{
a numerical vector of error values
}
\description{
The supplied phylogeny (\code{phylogeny}) is the true/known phylogeny.
From the phylogeny, already an alignment is simulated and saved
as a FASTA file with name \code{alignment_params$fasta_filename}.
}
\details{
The posterior phylogenies are compared to the true/known phylogeny
using the nLTT statistics. These nLTT statistics, all with values
betweem (including) zero and (including) one, are returned.
}
\examples{
if (beautier::is_on_ci()) {

  phylogeny <- ape::read.tree(text = "(((A:1, B:1):1, C:2):1, D:3);")

  # 'phylo_to_errors' expects an alignment file to be present
  alignment_params <- create_test_alignment_params()

  # Create the alignment
  create_tral_file(
    phylogeny = phylogeny,
    alignment_params = alignment_params
  )
  experiment <- create_test_gen_experiment()

  # A normal user should never need to initialize the experiment,
  # as this is done by 'pir_run'.
  # A develop, however, that wants to call 'phylo_to_errors',
  # should initialaze as such
  experiment <- init_experiment(
    experiment = experiment,
    alignment_params = alignment_params
  )

  experiments <- list(experiment)

  if (rappdirs::app_dir()$os != "win" && is_beast2_installed()) {
    phylo_to_errors(
      phylogeny = phylogeny,
      alignment_params = alignment_params,
      experiment = experiment
    )
  }
}
}
\author{
Richèl J.C. Bilderbeek
}
